//+------------------------------------------------------------------+
//|                                                   MarketInfo.mq4 |
//|                                                  Sergey Mechanic |
//|        https://login.mql5.com/ru/users/sergey_mechanic/portfolio |
//+------------------------------------------------------------------+
#property copyright "Sergey Mechanic"
#property link      "https://login.mql5.com/ru/users/sergey_mechanic/portfolio"
#property version   "1.00"

void OnStart()
{
   string TradeAllowed;
   if(MarketInfo(_Symbol, MODE_TRADEALLOWED) == 1)
      TradeAllowed = "";
   else
      TradeAllowed = "";
      
   string SwapType;
   switch((int) MarketInfo(_Symbol, MODE_SWAPTYPE))
   {
      case 0:
      SwapType = " ";
      break;
      
      case 1:
      SwapType = "  ";
      break;
      
      case 2:
      SwapType = " ";
      break;
      
      case 3:
      SwapType = "  ";
      break;
      
      default:
      SwapType = "";
      break;
   }

   string ProfitMode;
   switch((int) MarketInfo(_Symbol, MODE_PROFITCALCMODE))
   {
      case 0:
      ProfitMode = "FOREX";
      break;
      
      case 1:
      ProfitMode = "CFD";
      break;
      
      case 2:
      ProfitMode = "Futures";
      break;
      
      default:
      ProfitMode = "";
      break;
   }
   
   string MarginCallMode;
   switch((int) MarketInfo(_Symbol, MODE_MARGINCALCMODE))
   {
      case 0:
      MarginCallMode = "FOREX";
      break;
      
      case 1:
      MarginCallMode = "CFD";
      break;
      
      case 2:
      MarginCallMode = "Futures";
      break;
      
      case 3:
      MarginCallMode = "CFD  ";
      break;
      
      default:
      MarginCallMode = "";
      break;
   }
   
   string TradeStarting;
   if(MarketInfo(_Symbol, MODE_STARTING) != 0)
      TradeStarting = TimeToStr((datetime) MarketInfo(_Symbol, MODE_STARTING), TIME_DATE);
   else
      TradeStarting = "-";
      
   string TradeEpiration;
   if(MarketInfo(_Symbol, MODE_EXPIRATION) != 0)
      TradeEpiration = TimeToStr((datetime) MarketInfo(_Symbol, MODE_EXPIRATION), TIME_DATE);
   else
      TradeEpiration = "-";

   string MktInfo =   _Symbol                                                                                               + "\n" +
                                                                                                                              "\n" +
                     "Bid\t\t\t\t"                          + DoubleToStr(MarketInfo(_Symbol, MODE_BID), _Digits)           + "\n" +
                     "Ask\t\t\t\t"                          + DoubleToStr(MarketInfo(_Symbol, MODE_ASK), _Digits)           + "\n" +
                     " \t\t\t"                  + DoubleToStr(MarketInfo(_Symbol, MODE_SPREAD), 0)              + "\n" +
                     "  \t\t"        + TimeToStr((datetime)MarketInfo(_Symbol, MODE_TIME), TIME_DATE|TIME_MINUTES|TIME_SECONDS) + "\n" +
                     " \t\t\t"               + DoubleToStr(MarketInfo(_Symbol, MODE_HIGH), _Digits)          + "\n" +
                     " \t\t\t"                + DoubleToStr(MarketInfo(_Symbol, MODE_LOW), _Digits)           + "\n" +
                                                                                                                              "\n" +
                     "  (Point)\t\t"            + DoubleToStr(MarketInfo(_Symbol, MODE_POINT), _Digits)         + "\n" +
                     "   (TickSize)\t"      + DoubleToStr(MarketInfo(_Symbol, MODE_TICKSIZE), _Digits)      + "\n" +
                     "    \t"      + DoubleToStr(MarketInfo(_Symbol, MODE_TICKVALUE), 2)           + "\n" +
                                                                                                                              "\n" +
                     " \t\t\t"                    + DoubleToStr(MarketInfo(_Symbol, MODE_LOTSIZE), 0)             + "\n" +
                     " \t\t\t"                + DoubleToStr(MarketInfo(_Symbol, MODE_MINLOT), 2)              + "\n" +
                     " \t\t\t"               + DoubleToStr(MarketInfo(_Symbol, MODE_MAXLOT), 2)              + "\n" +
                     " \t\t\t\t"                     + DoubleToStr(MarketInfo(_Symbol, MODE_LOTSTEP), 2)             + "\n" +
                                                                                                                              "\n" +
                     "  \t\t"         + ProfitMode                                                    + "\n" +
                     "   \t"    + MarginCallMode                                                + "\n" +
                     "   1 \t\t"       + DoubleToStr(MarketInfo(_Symbol, MODE_MARGININIT), 2)          + "\n" +
                     "   \t\t"      + DoubleToStr(MarketInfo(_Symbol, MODE_MARGINMAINTENANCE), 2)   + "\n" +
                     "  1 "                                                                                + "\n" +
                     ",   \t"      + DoubleToStr(MarketInfo(_Symbol, MODE_MARGINHEDGED), 2)        + "\n" +
                     "    1 "                                                                         + "\n" +
                     "   \t\t"     + DoubleToStr(MarketInfo(_Symbol, MODE_MARGINREQUIRED), 2)      + "\n" +
                     " 1   "                                                                           + "\n" +
                                                                                                                              "\n" +
                     "Stop level\t\t\t\t"                   + DoubleToStr(MarketInfo(_Symbol, MODE_STOPLEVEL), 0)           + "\n" +
                     "Freeze level\t\t\t"                   + DoubleToStr(MarketInfo(_Symbol, MODE_FREEZELEVEL), 0)         + "\n" +
                                                                                                                              "\n" +
                     "  \t\t"          + SwapType                                                      + "\n" +
                     "SWAP  \t\t"             + DoubleToStr(MarketInfo(_Symbol, MODE_SWAPLONG), 2)            + "\n" +
                     "SWAP  \t\t"            + DoubleToStr(MarketInfo(_Symbol, MODE_SWAPSHORT), 2)           + "\n" +
                                                                                                                              "\n" +
                     "  \t\t\t"             + TradeStarting                                                 + "\n" +
                     "  \t\t"            + TradeEpiration                                                + "\n" +
                                                                                                                              "\n" +
                     " \t\t"               + TradeAllowed;

                  
   MessageBox(MktInfo, "Market Information");

   return; 
}

